/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.activity;

import com.ibm.hwmca.fw.servlet.activity.ActivityManager;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ActivityMonitor
implements Filter {
    public static final String ATTR_WINDOW_NAMES = "util.defunctWindowNames";
    public static final String ATTR_DISCONNECT_REASON_CODE = "util.defunctReasonCode";
    public static final String ATTR_DISCONNECT_TIME = "util.disconnectTime";
    public static final String ATTR_HMC_SESSION_ID = "util.hmcSessionId";
    public static final String ATTR_TIMEZONE_ID = "util.timeZone";
    public static final String ATTR_DEFUNCT_FLAG = "util.defunctSession";
    public static final String ATTR_GAVE_MESSAGE_FLAG = "util.defunctSessionMessage";
    private static final String TRACE_MASKT = "XTIFMTRT";
    private static final String TRACE_MASKF = "XTIFMTRF";
    private static final String MESSAGE_JSP_FILE = "defunctCleanup.jsp";
    private String[] ignoreableURIprefixes;

    public void init(FilterConfig filterConfig) throws ServletException {
        InputStream prefixes = this.getClass().getResourceAsStream("ignorableURI.prefixes");
        if (prefixes == null) {
            throw new UnavailableException("Can't find ignorableURI.prefixes as resource");
        }
        BufferedReader in = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(prefixes, "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            throw new UnavailableException("I/O exception reading resource ignorableURI.prefixes: " + e.getMessage());
        }
        this.ignoreableURIprefixes = new String[lines.size()];
        lines.toArray(this.ignoreableURIprefixes);
    }

    public void doFilter(ServletRequest filterRequest, ServletResponse filterResponse, FilterChain chain) throws IOException, ServletException {
        if (!(filterRequest instanceof HttpServletRequest)) {
            chain.doFilter(filterRequest, filterResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)filterRequest;
        HttpServletResponse response = (HttpServletResponse)filterResponse;
        if (request.getParameter("hmcUnsolicited") != null) {
            chain.doFilter(filterRequest, (ServletResponse)response);
            return;
        }
        String uri = request.getServletPath();
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            chain.doFilter(filterRequest, (ServletResponse)response);
            return;
        }
        HMCSession hmcSession = HMCSession.getHMCSession(httpSession, false);
        if (hmcSession == null) {
            block17: {
                if (httpSession.getAttribute(ATTR_DEFUNCT_FLAG) != null) {
                    Trace.trace(TRACE_MASKT, "Processing request from defunct HTTP session with id " + httpSession.getId());
                    String shortURI = "";
                    int slash = uri.lastIndexOf(47);
                    if (slash != -1 && slash < uri.length() - 1) {
                        shortURI = uri.substring(slash + 1);
                    }
                    if (shortURI.equals(MESSAGE_JSP_FILE)) {
                        request.setAttribute("windowNames", httpSession.getAttribute(ATTR_WINDOW_NAMES));
                        String reconnectURI = this.getReconnectURI(httpSession);
                        if (reconnectURI != null) {
                            request.setAttribute("reconnectURI", (Object)reconnectURI);
                        }
                        request.setAttribute("disconnectReason", (Object)this.getDisconnectReasonMessageKey(httpSession));
                        request.setAttribute("disconnectTime", httpSession.getAttribute(ATTR_DISCONNECT_TIME));
                        request.setAttribute("userTimeZone", httpSession.getAttribute(ATTR_TIMEZONE_ID));
                        httpSession.setMaxInactiveInterval(60);
                        chain.doFilter(filterRequest, (ServletResponse)response);
                        return;
                    }
                    if (shortURI.equals("connect")) {
                        Trace.trace(TRACE_MASKT, "Invalidating defunct HTTP session and redirecting to provoke login prompt");
                        httpSession.invalidate();
                        StringBuffer redirectURL = request.getRequestURL();
                        String queryParms = request.getQueryString();
                        if (queryParms != null) {
                            redirectURL.append('?');
                            redirectURL.append(queryParms);
                        }
                        response.sendRedirect(response.encodeRedirectURL(redirectURL.toString()));
                    } else {
                        try {
                            int disconnectionReason = (Integer)httpSession.getAttribute(ATTR_DISCONNECT_REASON_CODE);
                            if (disconnectionReason != 7 && disconnectionReason != 1 && httpSession.getAttribute(ATTR_GAVE_MESSAGE_FLAG) == null) {
                                httpSession.setAttribute(ATTR_GAVE_MESSAGE_FLAG, (Object)"true");
                                Trace.trace(TRACE_MASKT, "Dispatching request from defunct HTTP session to launchDefunctCleanup.jsp");
                                request.getRequestDispatcher("/tasks/launchDefunctCleanup.jsp").forward((ServletRequest)request, (ServletResponse)response);
                                break block17;
                            }
                            Trace.trace(TRACE_MASKT, "Dispatching request from defunct HTTP session to closeWindow.jsp");
                            request.getRequestDispatcher("/tasks/closeWindow.jsp").forward((ServletRequest)request, (ServletResponse)response);
                        }
                        catch (ServletException e) {
                            Trace.trace(TRACE_MASKT, "Ignoring ServletException trying to dispatch request");
                            Trace.trace(TRACE_MASKT, (Object)e);
                            chain.doFilter(filterRequest, (ServletResponse)response);
                        }
                        catch (IOException e) {
                            Trace.trace(TRACE_MASKT, "Ignoring IOException trying to dispatch request");
                            Trace.trace(TRACE_MASKT, e);
                            chain.doFilter(filterRequest, (ServletResponse)response);
                        }
                    }
                } else {
                    chain.doFilter(filterRequest, (ServletResponse)response);
                }
            }
            return;
        }
        for (int i = 0; i < this.ignoreableURIprefixes.length; ++i) {
            if (!uri.startsWith(this.ignoreableURIprefixes[i])) continue;
            chain.doFilter(filterRequest, (ServletResponse)response);
            return;
        }
        ActivityManager.getActivityManager().markActive(hmcSession);
        chain.doFilter(filterRequest, (ServletResponse)response);
    }

    private String getReconnectURI(HttpSession httpSession) {
        HMCSession hmcSession = HMCSession.getHMCSession((String)httpSession.getAttribute(ATTR_HMC_SESSION_ID));
        if (hmcSession == null) {
            return null;
        }
        if (!hmcSession.isDisconnected()) {
            return null;
        }
        return ServletRuntime.getRuntime().getHMCContextPath() + "/connect?session=" + hmcSession.getSessionId() + "&creationTime=" + hmcSession.getCreationTime().getTime() + "&option=closeWindow";
    }

    private String getDisconnectReasonMessageKey(HttpSession httpSession) {
        int disconnectReason = (Integer)httpSession.getAttribute(ATTR_DISCONNECT_REASON_CODE);
        return HMCSession.getDisconnectReasonMessageKey(disconnectReason);
    }

    public void destroy() {
        this.ignoreableURIprefixes = null;
    }
}

